//This file is part of The BBCut Library. Copyright (C) 2001  Nick M.Collins distributed under the terms of the GNU General Public License full notice in file BBCutLibrary.help

 //created by Nick Collins 10/10/01 
//this is fully general version- 
//quick versions StatBalStream,Pstatbal with no normalisation, no zero weights! 
//my own normalisation step- discussed with Charles Ames- he no longer wants to think about it...

//possible improvement- search takes first occuring state if draw in expected increments- can improve this to random choice? 
//not without extra computational effort- also pointless in longterm unless hetero is zero

//specific streams class and patterns class

//if weight < 0.00001 taken as zero (floating point 0.0 must be tested thus)
//zero weighted states do not have their statistics changed in normalisation
//so may 'turn off' an option for a while

//assumes that states and weights arrays are the same size
//change weights, states, heterogeneity, length, accent whenever desired, but don't change size of weights array= size of states array

StatBalNormStream : Stream {
	var <>states,<>weights,<>heterogeneity,<>length,<counter,<stats,<>accent=1;

*new { arg states, weights, heterogeneity=0.0, length=inf;	

		^super.new.states_(states).weights_(weights).heterogeneity_(heterogeneity).length_(length).reset
	}
	
	next {	//v is expected increment
			var choice,best,numnonzero,temp,actual,deduct;
			
			^if (counter >= length, {
				nil
			},{
				
				//stat balance procedure
				
				//create expected increments, choosing least as candidate
				choice=states.size.rand;
				
				best=inf;
				
				numnonzero=0;
				
				weights.do(
				{
				arg val,i;
				
				if(val>0.00001,
				{
				temp= stats.at(i)+((accent+(heterogeneity*(1.0.rand)))/val);
				
				if(temp<best,{best=temp;choice=i;});
			
				numnonzero= numnonzero+1;
				}
				)
				
				}
				);
				
				
				if(numnonzero>0,{
				//actual increment
				actual= accent/weights.at(choice);
					
				
				//normalise, updating statistics
				
				//could take numnonzero-1, don't deduct from incremented stat
				deduct= actual/numnonzero;
				
				weights.do(
				{
				arg val,i;
				
				if(i==choice,
				{
				stats.put(i,stats.at(i)+actual-deduct)
				},
				{
				if(val>0.00001,
				{
				stats.put(i,stats.at(i)-deduct)
				}
				)
				
				}
				)
				
				}
				)
				
				}
				);
					
				counter = counter + 1;	
				states.at(choice)
				
			})	
	}
	
	reset {
	counter = 0;		
	stats= Array.fill(states.size,{0.0}); 
	}

}			

